close all
clear all
global u_t u_t1 jft
warning off
clc


% Import forecast errors
addpath('C:\Dropbox\bpea\forecasts');

% residuals from GB and SPF forecasts
eGB=csvread('res_gb.csv',1,1);
eSPF=csvread('res_spf.csv',1,1);

% residuals from SSUR2 in real time
eSSUR2=csvread('res_ssur2.csv',1,1);
eSS=eSSUR2;

%use data rounded at first digit
errorsStaff=[eGB eSPF];
name=['eGB '; 'eSPF'; ];
errorsStaff=errorsStaff(1:end-0,:);

for j=1:round(size(errorsStaff,2)/4)-1
    
    eStaff=errorsStaff(:,1+(j-1)*5:(j)*5);
    
    disp(horzcat('RMSEs Staff forecast:' ));
    disp(horzcat('Model_' ,num2str(name(j,:)) ));
    disp(num2str((sum(eStaff.^2,1)./length(eStaff)).^.5))
    
    
    disp(' ')
    disp(horzcat('Relative MSE ofSSUR forecast:' ));
    disp(horzcat('Var_' ,num2str(name(j,:)), 'model / Var SS model:' ));
    disp(num2str(sum(eStaff.^2,1)./sum(eSS.^2,1)))
    
    
    dssr=eStaff.^2-eSS.^2;
    disp(horzcat([' ']));
    Pval=[];
    for i=1:size(eSS,2)
        [teststat,critval,pval]=CPAtest(dssr(:,i),ones(length(dssr),1),i);
        Pval=[Pval pval];
    end
    disp(horzcat('Giacomini-White test at forecast horizon, p-values' ));
    disp(num2str(Pval))
        disp('**********')
end


% MSE and RMSE of SSUR2
disp(' ')
disp('**********')
disp(horzcat('MSE SSUR2:' ));
disp(num2str(sum(eSS.^2,1)./length(eStaff)))
disp(horzcat('RMSE SSUR2:' ));
disp(num2str(((sum((eSS).^2,1))./length(eSS)).^.5))


